/**
 * Created by qjon on 08.01.14.
 */
module.exports = {
    database: {}
    ,output: {}
    ,rooms: []
    ,createChatRoom: function(roomId){
        var database = this.database;
        var output = this.output;
        function Room(){
            this.id = roomId;
            this.history = [];
            this.clients = [];
            this.usernames = {};

            this.addClient = function(socket, user){
                this.usernames[socket.id] = user;
                output.info('Add client (handshake: ' + socket.id + ') to ChatRoom (ID: ' + this.id + ')');
            }

            this.removeClient = function(socket){
                if(this.usernames[socket.id] != null)
                {
                    delete this.usernames[socket.id];
                }
            }

            this.addMsg = function(msg, socketId){
                var message = {
                    message: msg
                    ,group_id: this.id
                    ,user_id: this.usernames[socketId].id
                    ,username: this.usernames[socketId].name
                    ,create_at: new Date()
                }
                return message;
            }

            this.getUsers = function(){
                return this.usernames;
            }
        }
        return new Room();
    }
    ,find: function(roomId){
        var room = false;
        this.rooms.forEach(function(ChatRoom){
            if(ChatRoom.id == roomId)
            {
                room = ChatRoom;
            }
        });

        return room;
    }
    ,addChatRoom: function(roomId){
        var foundRoom = this.find(roomId);

        if(foundRoom == false)
        {
            foundRoom = this.createChatRoom(roomId)
            this.rooms.push(foundRoom);
            this.output.info('Create new ChatRoom - ID: ' + roomId);
        }
        else
        {
            this.output.info('ChatRoom exist - ID: ' + roomId);
        }

        return foundRoom;
    }
}